<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Bank;

class BankController extends Controller
{
    public function index()
    {
        $banks = Bank::latest()->paginate(10);
        return view('admin.bank.index', compact('banks'));
    }

    public function create()
    {
        return view('admin.bank.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'bank' => 'required|string|max:255',
            'address' => 'nullable|string|max:255',
            'bank_code' => 'required|string|max:50|unique:banks,bank_code',
            'is_active' => 'required|boolean',
        ]);

        Bank::create($request->all());

        return redirect()->route('admin.bank.index')->with('success', 'Bank created successfully.');
    }

    public function edit(Bank $bank)
    {
        return view('admin.bank.edit', compact('bank'));
    }

    public function update(Request $request, Bank $bank)
    {
        $request->validate([
            'bank' => 'required|string|max:255',
            'address' => 'nullable|string|max:255',
            'bank_code' => 'required|string|max:50|unique:banks,bank_code,' . $bank->id,
            'is_active' => 'required|boolean',
        ]);

        $bank->update($request->all());

        return redirect()->route('admin.bank.index')->with('success', 'Bank updated successfully.');
    }

    public function destroy(Bank $bank)
    {
        $bank->delete();
        return redirect()->route('admin.bank.index')->with('success', 'Bank deleted successfully.');
    }
}
