<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bank;
use App\Models\Branch;
use App\Models\Agent;

class DashboardController extends Controller
{
    public function index()
    {
        // -----------------------
        // 📊 Dashboard Stats
        // -----------------------
        $stats = [
            'total_banks' => Bank::count(),   // Total banks
            'total_branches' => Branch::count(), // Total branches
            'total_agents' => Agent::count(),  // Total agents
            'active_banks' => Bank::where('is_active', 1)->count(),
            'active_branches' => Branch::where('is_active', 1)->count(),
            'active_agents' => Agent::where('is_active', 1)->count(),
        ];

        // -----------------------
        // 🏦 Recent Branches
        // -----------------------
        $recentBranches = Branch::with('bank')
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        // -----------------------
        // 👨‍💼 Recent Agents
        // -----------------------
        $recentAgents = Agent::with(['bank', 'branch'])
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        // -----------------------
        // Return View
        // -----------------------
        return view('admin.dashboard', compact('stats', 'recentBranches', 'recentAgents'));
    }
}
