@extends('admin.layouts.app')

@section('title', 'Add Agent')

@section('content')
    <div class="card">
        <div class="card-header bg-dark text-white">
            <h4 class="mb-0">➕ Add Agent</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.agent.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Bank</label>
                        <select name="bank_id" class="form-select" id="bankDropdown" required>
                            <option value="">Select Bank</option>
                            @foreach($banks as $bank)
                                <option value="{{ $bank->id }}">{{ $bank->bank }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Branch</label>
                        <select name="branch_id" class="form-select" id="branchDropdown" required>
                            <option value="">Select Branch</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Designation</label>
                        <input type="text" name="designation" placeholder="Enter the desigantaion.." class="form-control"
                            required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" name="name" placeholder="Enter the name..." class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Mobile Number</label>
                        <input type="tel" name="mobile_number" placeholder="Enter mobile number..." class="form-control"
                            pattern="[0-9]{10}" maxlength="10" required>
                        <small class="text-muted">Enter a 10-digit mobile number</small>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">WhatsApp Number</label>
                        <input type="tel" name="whatsapp_number" placeholder="Enter WhatsApp number..." class="form-control"
                            pattern="[0-9]{10}" maxlength="10" required>
                        <small class="text-muted">Enter a 10-digit WhatsApp number</small>
                    </div>

                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" placeholder="Enter the email..." class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" placeholder="Enter the apssword.." class="form-control"
                            required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Profile Image</label>
                        <input type="file" name="image" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <select name="is_active" class="form-select">
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <button type="submit" class="btn btn-success">Save Agent</button>
                    <a href="{{ route('admin.agent.index') }}" class="btn btn-light">Cancel</a>
                </div>
            </form>
        </div>
    </div>

    {{-- ✅ Ajax script for dependent branch dropdown --}}
    <script>
        document.getElementById('bankDropdown').addEventListener('change', function () {
            let bankId = this.value;
            let branchDropdown = document.getElementById('branchDropdown');

            branchDropdown.innerHTML = '<option value="">Loading...</option>';

            fetch(`/admin/branches-by-bank/${bankId}`)
                .then(res => res.json())
                .then(data => {
                    branchDropdown.innerHTML = '<option value="">Select Branch</option>';
                    data.forEach(branch => {
                        branchDropdown.innerHTML += `<option value="${branch.id}">${branch.branch_address}</option>`;
                    });
                });
        });
    </script>
@endsection