@extends('admin.layouts.app')

@section('title', 'Agents List')

@push('styles')
    {{-- ✅ Bootstrap Icons --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
@endpush

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h4 class="mb-0">All Agents</h4>
            <a href="{{ route('admin.agent.create') }}" class="btn btn-success btn-sm">
                <i class="bi bi-plus-circle"></i> Add Agent
            </a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success" id="success-alert">{{ session('success') }}</div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Bank</th>
                            <th>Branch</th>
                            <th>Designation</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>mobile_number</th>
                            <th>whatsapp_number</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($agents as $agent)
                            <tr>
                                <td>{{ $agent->id }}</td>
                                <td>{{ $agent->bank->bank ?? 'N/A' }}</td>
                                <td>{{ $agent->branch->branch_address ?? 'N/A' }}</td>
                                <td>{{ $agent->designation }}</td>
                                <td>{{ $agent->name }}</td>
                                <td>{{ $agent->email }}</td>
                                <td>{{ $agent->mobile_number }}</td>
                                <td>{{ $agent->whatsapp_number }}</td>
                                <td>
                                    @if($agent->image)
                                        <img src="{{ asset('storage/' . $agent->image) }}" width="50" class="rounded">
                                    @else
                                        <span class="text-muted">No Image</span>
                                    @endif
                                </td>
                                <td>
                                    @if($agent->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.agent.edit', $agent->id) }}" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil-square"></i>
                                    </a>
                                    <form action="{{ route('admin.agent.destroy', $agent->id) }}" method="POST"
                                        class="d-inline">
                                        @csrf @method('DELETE')
                                        <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this agent?')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">No agents found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{ $agents->links() }}
        </div>
    </div>

    {{-- ✅ Auto-hide success alert --}}
    @push('scripts')
        <script>
            setTimeout(() => {
                let alert = document.getElementById('success-alert');
                if (alert) {
                    alert.style.display = 'none';
                }
            }, 2000);
        </script>
    @endpush
@endsection