@extends('admin.layouts.app')

@section('title', 'Add New Bank')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Add New Bnak</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.bank.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="bank" class="form-label">Bank Name</label>
                                    <input type="text" class="form-control @error('bank') is-invalid @enderror" id="bank"
                                        name="bank" value="{{ old('bank') }}" placeholder="Enter full name" required>
                                    @error('bank')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="address" class="form-label"> Address</label>
                                    <input type="address" class="form-control @error('address') is-invalid @enderror"
                                        id="address" name="address" value="{{ old('address') }}"
                                        placeholder="Enter address address" required>
                                    @error('address')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="bank_code" class="form-label">Bank Code</label>
                                    <input type="text" class="form-control @error('bank_code') is-invalid @enderror"
                                        id="bank_code" name="bank_code" value="{{ old('bank_code') }}"
                                        placeholder="Enter bank_code.." required>
                                    @error('bank_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select class="form-select" id="is_active" name="is_active">
                                        <option value="1" selected>Active</option>
                                        <option value="0">Inactive (New)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                </div>
                <div class="mt-3">
                    <button type="submit" class="btn btn-primary mb-2">Create Bank</button>
                    <a href="{{ route('admin.bank.index') }}" class="btn btn-light mb-2 ">Cancel</a>
                </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection