@extends('admin.layouts.app')

@section('title', 'Add Gold Item')

@section('content')
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0">Add Gold Item</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.gold_items.store') }}" method="POST">
                        @csrf

                        {{-- Customer --}}
                        <div class="mb-3">
                            <label class="form-label">Select Customer <span class="text-danger">*</span></label>
                            <select name="customer_id" class="form-select @error('customer_id') is-invalid @enderror" required>
                                <option value="">-- Select Customer --</option>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->full_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('customer_id') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Description --}}
                        <div class="mb-3">
                            <label class="form-label">Description <span class="text-danger">*</span></label>
                            <input type="text" name="description" class="form-control @error('description') is-invalid @enderror"
                                   value="{{ old('description') }}" placeholder="Enter item description" required>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Quantity --}}
                        <div class="mb-3">
                            <label class="form-label">Quantity <span class="text-danger">*</span></label>
                            <input type="number" name="quantity" class="form-control @error('quantity') is-invalid @enderror"
                                   value="{{ old('quantity', 1) }}" placeholder="Enter quantity" required>
                            @error('quantity') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Gross Weight --}}
                        <div class="mb-3">
                            <label class="form-label">Gross Weight (g) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="gross_weight" class="form-control @error('gross_weight') is-invalid @enderror"
                                   value="{{ old('gross_weight') }}" placeholder="Enter gross weight" required>
                            @error('gross_weight') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Stone Weight --}}
                        <div class="mb-3">
                            <label class="form-label">Stone Weight (g) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="stone_weight" class="form-control @error('stone_weight') is-invalid @enderror"
                                   value="{{ old('stone_weight') }}" placeholder="Enter stone weight" required>
                            @error('stone_weight') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Purity --}}
                        <div class="mb-3">
                            <label class="form-label">Purity (Carat) <span class="text-danger">*</span></label>
                            <input type="number" name="purity" class="form-control @error('purity') is-invalid @enderror"
                                   value="{{ old('purity') }}" placeholder="Enter purity (e.g. 24)" required>
                            @error('purity') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Rate per Gram --}}
                        <div class="mb-3">
                            <label class="form-label">Rate per Gram <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="rate_per_gram" class="form-control @error('rate_per_gram') is-invalid @enderror"
                                   value="{{ old('rate_per_gram') }}" placeholder="Enter rate per gram" required>
                            @error('rate_per_gram') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Remarks --}}
                        <div class="mb-3">
                            <label class="form-label">Remarks</label>
                            <textarea name="remarks" class="form-control @error('remarks') is-invalid @enderror"
                                      placeholder="Optional remarks">{{ old('remarks') }}</textarea>
                            @error('remarks') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        {{-- Submit --}}
                        <div class="mt-3">
                            <button type="submit" class="btn btn-primary">Save Gold Item</button>
                            <a href="{{ route('admin.gold_items.index') }}" class="btn btn-light">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
