@extends('admin.layouts.app')

@section('title', 'Invoices')

@section('content')
    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">Invoices</h4>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Invoice</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($agents as $agent)
                        <tr>
                            <td>{{ $agent->id }}</td>
                            <td>{{ $agent->name }}</td>
                            <td>{{ $agent->email }}</td>
                            <td>{{ $agent->mobile_number }}</td>
                            <td>
                                <a href="{{ route('admin.agent.certificate', $agent->id) }}" class="btn btn-sm btn-danger">
                                    <i class="mdi mdi-file-pdf-box"></i> PDF
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            {{ $agents->links() }}
        </div>
    </div>
@endsection