<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ForgotPasswordController;
use App\Http\Controllers\Admin\GoldItemController;
use App\Http\Controllers\Admin\SubcategoryController;
use App\Http\Controllers\Admin\WebsiteBannerController;
use App\Http\Controllers\Admin\WebsiteSettingsController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\BranchController;
use App\Http\Controllers\Admin\BankController;
use App\Http\Controllers\Admin\AgentController; // ✅ Added

use Illuminate\Support\Facades\Route;

// Admin Routes 
Route::prefix('admin')->name('admin.')->group(function () {
    // Guest routes (login)
    Route::middleware('guest:admin')->group(function () {
        Route::get('login', [AdminController::class, 'showLoginForm'])->name('login');
        Route::post('login', [AdminController::class, 'login']);

        // Forgot Password Routes
        Route::get('forgot-password', [ForgotPasswordController::class, 'showForgotForm'])->name('forgot-password');
        Route::post('send-otp', [ForgotPasswordController::class, 'sendOTP'])->name('send-otp');
        Route::get('verify-otp', [ForgotPasswordController::class, 'showVerifyOTP'])->name('verify-otp');
        Route::post('verify-otp', [ForgotPasswordController::class, 'verifyOTP'])->name('verify-otp');
        Route::get('reset-password', [ForgotPasswordController::class, 'showResetForm'])->name('reset-password');
        Route::post('reset-password', [ForgotPasswordController::class, 'resetPassword'])->name('reset-password');
    });

    // Protected admin routes
    Route::middleware('admin')->group(function () {
        Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::post('logout', [AdminController::class, 'logout'])->name('logout');

        // Subcategories
        Route::resource('subcategories', SubcategoryController::class);
        Route::post('subcategories/{subcategory}/toggle-status', [SubcategoryController::class, 'toggleStatus'])->name('subcategories.toggle-status');

        // Gold Items
        Route::resource('gold_items', GoldItemController::class)
            ->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);

        // Customers
        Route::resource('customers', CustomerController::class);
        Route::get('customers/search', [CustomerController::class, 'search'])->name('customers.search');
        Route::post('customers/{customer}/toggle-status', [CustomerController::class, 'toggleStatus'])->name('customers.toggle-status');

        // Website Banners
        Route::resource('website-banners', WebsiteBannerController::class);
        Route::post('website-banners/{website_banner}/toggle-status', [WebsiteBannerController::class, 'toggleStatus'])->name('website-banners.toggle-status');

        // Contacts
        Route::resource('contacts', ContactController::class)->except(['create', 'store']);
        Route::post('contacts/{contact}/update-status', [ContactController::class, 'updateStatus'])->name('contacts.update-status');

        // ✅ Banks
        Route::resource('bank', BankController::class);

        // ✅ Branches
        Route::resource('branch', BranchController::class);

        // ✅ Agents
        Route::resource('agent', AgentController::class);
        // routes/web.php (inside admin middleware group)
        Route::get('invoices', [AgentController::class, 'invoiceIndex'])->name('invoices');

        // ✅ Agent Certificate PDF
        Route::get('agent/{id}/certificate', [AgentController::class, 'certificate'])->name('agent.certificate');

        // ✅ AJAX: Get Branches by Bank (for dependent dropdown)
        Route::get('branches-by-bank/{bank}', function ($bankId) {
            return \App\Models\Branch::where('bank_id', $bankId)->get();
        })->name('branches.by-bank');

        // Contact Details
        Route::get('contact-details', function () {
            $id = \App\Models\WebsiteSetting::first()?->id ?? 1;
            return redirect()->route('admin.contact-details.edit', $id);
        })->name('contact-details.index');

        Route::get('contact-details/{id}', [WebsiteSettingsController::class, 'show'])->name('contact-details.show');
        Route::get('contact-details/{id}/edit', [WebsiteSettingsController::class, 'edit'])->name('contact-details.edit');
        Route::put('contact-details/{id}', [WebsiteSettingsController::class, 'update'])->name('contact-details.update');

        // Change Credentials
        Route::get('change-credentials', function () {
            return view('admin.change-credentials.index');
        })->name('change-credentials');

        Route::put('change-credentials', function () {
            return redirect()->back()->with('success', 'Password updated successfully!');
        })->name('change-credentials.update');
    });
});

Route::get('/', function () {
    return redirect()->route('admin.login');
});
