<?php $__env->startSection('title', 'Customers - Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Customers</h4>
                    
                    <a href="<?php echo e(route('admin.customers.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="ri-add-line align-middle me-1"></i> Add Customer
                    </a>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-5"> 
                            <input type="text" id="searchInput" class="form-control"
                                placeholder="Search by name, email, phone..." autocomplete="off">
                        </div>
                        <div class="col-md-4"> 
                            <select id="statusFilter" class="form-select">
                                <option value="">All Statuses</option>
                                <option value="active">Active Borrowers</option>
                                <option value="new">New Applicants</option>
                                <option value="blacklisted">Blacklisted</option>
                            </select>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th class="text-nowrap">Sr.n</th>
                                    <th class="text-nowrap">Name</th>
                                    <th class="text-nowrap">Email</th>
                                    <th class="text-nowrap">Phone</th>
                                    <th class="text-nowrap">Status</th>
                                    <th class="text-nowrap">Joining Date</th>
                                    <th class="text-nowrap">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="customersTableBody">
                                <?php echo $__env->make('admin.customers.partials.table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <?php echo $__env->make('admin.customers.partials.pagination', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            $(document).ready(function () {
                let searchTimeout;

                // --- Main AJAX Function to Load Customers ---
                function loadCustomers(page = 1) {
                    const query = $('#searchInput').val();
                    const status = $('#statusFilter').val(); // Get status filter value

                    $.ajax({
                        url: '<?php echo e(route('admin.customers.index')); ?>',
                        method: 'GET',
                        data: {
                            search: query,
                            status: status, // Send status data
                            page: page
                        },
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        success: function (response) {
                            updateTable(response);

                            // Update browser URL
                            const url = new URL(window.location);
                            if (query) {
                                url.searchParams.set('search', query);
                            } else {
                                url.searchParams.delete('search');
                            }

                            if (status) { // Add status to URL
                                url.searchParams.set('status', status);
                            } else {
                                url.searchParams.delete('status');
                            }

                            if (page && page > 1) {
                                url.searchParams.set('page', page);
                            } else {
                                url.searchParams.delete('page');
                            }

                            // Push state to history
                            window.history.pushState({}, '', url);
                        },
                        error: function () {
                            console.log('Search or filter failed');
                        }
                    });
                }

                // --- Event Handlers ---

                // 1. Search Input (Debounced)
                $('#searchInput').on('input', function () {
                    clearTimeout(searchTimeout);
                    searchTimeout = setTimeout(function () {
                        loadCustomers(1); // Reset to page 1
                    }, 300);
                });

                // 2. Status Filter (Instant)
                $('#statusFilter').on('change', function () {
                    loadCustomers(1); // Reset to page 1
                });

                // 3. Pagination Click
                $(document).on('click', '.pagination a', function (e) {
                    e.preventDefault();
                    const href = $(this).attr('href');
                    const url = new URL(href);
                    const page = url.searchParams.get('page') || 1;

                    loadCustomers(page); // Load the specific page

                    // Optional: Scroll to top of table
                    $('html, body').animate({
                        scrollTop: $('.table-responsive').offset().top - 100
                    }, 300);
                });

                // --- Reusable Function to Update Content ---
                function updateTable(response) {
                    if (response.table) {
                        // Handle JSON response
                        $('#customersTableBody').html(response.table);
                        $('.pagination-container').html(response.pagination || '');
                    } else {
                        // Handle full HTML response
                        const tempDiv = $('<div>').html(response);
                        const newTableBody = tempDiv.find('#customersTableBody').html();
                        const newPagination = tempDiv.find('.pagination-container').html();

                        $('#customersTableBody').html(newTableBody);
                        $('.pagination-container').html(newPagination || '');
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\LENOVO\Desktop\loanmanagement\resources\views/admin/customers/index.blade.php ENDPATH**/ ?>