<?php $__env->startSection('title', 'Banks List'); ?>


<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12">

            
            <?php if(session('success')): ?>
                <div id="flash-message" class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            
            <div class="card shadow-sm border-0">
                <div class="card-header d-flex justify-content-between align-items-center bg-dark text-white">
                    <h4 class="card-title mb-0">🏦 All Banks</h4>
                    <!-- ✅ Add Bank Button -->
                    <a href="<?php echo e(route('admin.bank.create')); ?>" class="btn btn-sm btn-success">
                        <i class="bi bi-plus-circle"></i> Add Bank
                    </a>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle text-center">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Bank Name</th>
                                    <th>Address</th>
                                    <th>Bank Code</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($bank->id); ?></td>
                                        <td><?php echo e($bank->bank); ?></td>
                                        <td><?php echo e($bank->address); ?></td>
                                        <td><?php echo e($bank->bank_code); ?></td>
                                        <td>
                                            <?php if($bank->is_active): ?>
                                                <span class="badge bg-success"><i class="bi bi-check-circle"></i> Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger"><i class="bi bi-x-circle"></i> Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.bank.edit', $bank->id)); ?>" class="btn btn-sm btn-primary">
                                                <i class="bi bi-pencil-square"></i> Edit
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center text-muted">🚫 No banks found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="mt-3 d-flex justify-content-center">
                        <?php echo e($banks->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <script>
        setTimeout(() => {
            let msg = document.getElementById('flash-message');
            if (msg) {
                msg.classList.remove('show');
                msg.classList.add('fade');
                setTimeout(() => msg.remove(), 500);
            }
        }, 2000);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\LENOVO\Desktop\loanmanagement\resources\views/admin/bank/index.blade.php ENDPATH**/ ?>